var appid="APPID=Hier APPID einfügen";
var date, dateObj,localDateObj,localDate,jForecast,jForecast2,jHSForecast,db;
var locations=new Array();

var weekday=[];
weekday.push("Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag");


Date.prototype.addHours= function(h){
    this.setHours(this.getHours()+h);
    return this;
}

window.onload = initApp;



function initializeDB() {
    if (!window.indexedDB) {
     alert("Indexed DB is not supported.");
    } 
    
    var request = indexedDB.open('locationDB', 1);
    
    request.onsuccess = function (e) {
     db = e.target.result;
     loadLastLocations();
    }
    
    request.onerror = function (e) {
     console.log("db error");
    };
    
    request.onupgradeneeded = function (e) {
     
     db = e.target.result;
    
     if (db.objectStoreNames.contains("locations")) {
     db.deleteObjectStore("locations");
     }

     var objectStore = db.createObjectStore('locations', { keyPath: 'id', autoIncrement: true });
    };
}

function addLocationToDB(location,gID)
{
     var transaction = db.transaction([ 'locations' ], 'readwrite');
     var value = {};
     value.location = location;
     value.gID = gID;

     var store = transaction.objectStore('locations');
     var request = store.add(value);
     request.onsuccess = function (e) {
        $('#lastResultsDB').html("");
        $('#results').css("height", "0px");
        loadLastLocations();
     };
     request.onerror = function (e) {
     	console.log("db error");
     }
}

function loadLastLocations()
{
	 var transaction = db.transaction([ 'locations' ]);
     var store = transaction.objectStore('locations');
     var counter=0;
       
     store.openCursor().onsuccess = function (e) {
     var cursor = e.target.result;

     if (cursor) {
     var value = cursor.value;
    	locations[counter]=cursor.value;	
    	counter++;
        cursor.continue();
     }
     else
     {
         getForecastHomeScreen()
     }
    };
}

function deleteLocationFromDB(id)
{
	var location=$('#'+id).attr('locationName');
	var geoID=$('#'+id).attr('geoID');

	 var transaction = db.transaction([ 'locations' ], "readwrite");
     var store = transaction.objectStore('locations');
     var counter=0;
       
     store.openCursor().onsuccess = function (e) {
     var cursor = e.target.result;

     if (cursor) {
     	var value = cursor.value;

        if(value.location==location && value.gID==geoID)
        {
        	cursor.delete();
        }
        else
        {
        	cursor.continue();
        } 
     }
    };	
}

function getForecastHomeScreen()
{
     var startIdx=locations.length-10;
     var endIdx=startIdx+10;
     if (startIdx<0)
     {
     	startIdx=0;
     }
     if(endIdx>locations.length)
     {
     	endIdx=locations.length;
     }	
     
     var tempLocations=new Array();
     var tempIDs=new Array();
     var tempCount=0;

     for(var i=endIdx-1; i>=startIdx; i--)
     {
     	var value =locations[i];
		if(i==startIdx)
		{
			tempLocations[tempCount]=value.location;
			tempIDs[tempCount]=value.gID;
			tempCount++;
		}
		else
		{
			tempLocations[tempCount]=value.location;
			tempIDs[tempCount]=value.gID;
			tempCount++;
		}	
     }  

	$("#lastResultsDB").html("");
	for(var i=0; i<tempLocations.length;i++)
    {
    	loadHomeScreenData(tempIDs[i],i);
	 }
}

function loadHomeScreenData(gID,i){

    	var xhr = new XMLHttpRequest({mozSystem: true});
		xhr.open("GET", "http://api.openweathermap.org/data/2.5/weather?id="+gID+"&units=metric&"+appid, true);
		xhr.onreadystatechange = function () {
	      if (xhr.status === 200 && xhr.readyState === 4) {
	    	  jHSForecast=JSON.parse(xhr.response);
	    	  var temp=JSON.parse(xhr.response);
			var htmlString="";
    		  	  
    		  htmlString+="<li data-icon='false' id='hsLocation"+i+"' locationName='"+temp["name"]+"' geoID='"+temp["id"]+"'><a href='#weatherPage'>"+temp["name"]+","+temp["sys"]["country"];
    		  if(temp["main"]["temp"] > 25){
    		  	
					htmlString+="<div class='tempListLocation tempg25'>";
				}
				else if(temp["main"]["temp"] > 20 && temp["main"]["temp"] <= 25){
					
					htmlString+="<div class='tempListLocation tempg20'>";
				}
				else if(temp["main"]["temp"] > 15 && temp["main"]["temp"] <= 20){
					
					htmlString+="<div class='tempListLocation tempg15'>";
				}
				else if(temp["main"]["temp"] > 0 && temp["main"]["temp"] <= 15){
					
					htmlString+="<div class='tempListLocation tempg0'>";
				}
				else if(temp["main"]["temp"] > -10 && temp["main"]["temp"] <= 0){
					
					htmlString+="<div class='tempListLocation tempgm10'>";
				}
				else if(temp["main"]["temp"] <= -10){
					
					htmlString+="<div class='tempListLocation tempkgm10'>";
				}

	    		 htmlString+=temp["main"]["temp"]+"°<img class='imgListLocation' alt='"+temp["weather"][0]["icon"]+".png' src='http://openweathermap.org/img/w/"+temp["weather"][0]["icon"]+".png'></div></a></li>";
	    	  
				$("#lastResultsDB").html($("#lastResultsDB").html()+htmlString);
	    	  	$('#lastResultsDB').listview('refresh');

			
    		  addlistenerFunc(i, temp["name"]+","+temp["sys"]["country"], temp["main"]["temp"]);
	      }
	  }
	  	xhr.onerror = function () {
	     alert(xhr.response);
		};
		xhr.send();	
}

function addlistenerFunc( i, location, mainTemp )
{	
	$('body').off("click","#hsLocation"+i)
	$('body').on("click","#hsLocation"+i,function(e){
		getForecast(location, mainTemp);
	})
}

function getForecast(location, mainTemp)
{		
	var xhr = new XMLHttpRequest({mozSystem: true});
	xhr.open("GET", "http://api.openweathermap.org/data/2.5/forecast?q="+location+"&units=metric&"+appid, true);	
	xhr.onreadystatechange = function () {
	      if (xhr.status === 200 && xhr.readyState === 4) {
	    	  jForecast=xhr.response;
	    	  getForecast2(location, mainTemp);
	      }
	  }

	xhr.onerror = function () {
	     alert(xhr.response);
	};
	xhr.send();
}

function getForecast2(location, mainTemp)
{	
	var days = 16;
	var xhr = new XMLHttpRequest({mozSystem: true});
	xhr.open("GET", "http://api.openweathermap.org/data/2.5/forecast/daily?q="+location+"&units=metric&cnt="+days+"&"+appid, true);	
	xhr.onreadystatechange = function () {
	      if (xhr.status === 200 && xhr.readyState === 4) {
	    	  jForecast2=xhr.response;
	    	  displayForecastMain(location, mainTemp);
	      }
	  }

	xhr.onerror = function () {
	     alert(xhr.response);
	};
	xhr.send();
}

function getLocalDate(localDateString) {
	var dateArray = localDateString.split(' ');
    var year = dateArray[0].split('-');
    var time = dateArray[1].split(':');
    if((time[1]*1)>45)
	{
    	time[1]=0;
    	localDateObj = new Date(year[0]*1, year[1]-1, year[2]*1, time[0]*1, time[1]*1, time[2]*1).addHours(1);
	}
    else
    {
    	localDateObj = new Date(year[0]*1, year[1]-1, year[2]*1, time[0]*1, time[1]*1, time[2]*1)
    }   	
    localDate=dateArray[0];
}


function displayForecastMain(location, mainTemp) 
{
	var weatherData=JSON.parse(jForecast);
	var weatherData2=JSON.parse(jForecast2);
	$('#results').html("");
	
	getLocalDate(weatherData["list"][0]["dt_txt"]);
	
	var htmlString="";
	var tempDate=new Date(localDateObj);
	var tempDateDays = new Date(localDateObj.getFullYear(), localDateObj.getMonth(), localDateObj.getDate());
	
	for(var i=0;i<weatherData["cnt"];i++)
	{
		var month = '0' + (tempDateDays.getMonth() + 1);
	    month = month.slice(-2, (month.length - 2) + 3);
	    var day = '0' + tempDateDays.getDate();
		day = day.slice(-2, (day.length - 2) + 3);
		var dateToDisplay=day+"."+month+".";


			htmlString+="<li><div class='list-hour-weatherText'><div class='list-hour-top'>"+dateToDisplay+"<br>"+tempDate.getHours()+":00</div><div class='list-hour-bottom'>";
			
			if(weatherData["list"][i]["main"]["temp"] > 25){
					htmlString+="<div class='temp-hour tempg25'>";
				}
				else if(weatherData["list"][i]["main"]["temp"] > 20 && weatherData["list"][i]["main"]["temp"] <= 25){
					htmlString+="<div class='temp-hour tempg20'>";
				}
				else if(weatherData["list"][i]["main"]["temp"] > 15 && weatherData["list"][i]["main"]["temp"] <= 20){
					htmlString+="<div class='temp-hour tempg15'>";
				}
				else if(weatherData["list"][i]["main"]["temp"] > 0 && weatherData["list"][i]["main"]["temp"] <= 15){
					htmlString+="<div class='temp-hour tempg0'>";
				}
				else if(weatherData["list"][i]["main"]["temp"] > -10 && weatherData["list"][i]["main"]["temp"] <= 0){
					htmlString+="<div class='temp-hour tempgm10'>";
				}
				else if(weatherData["list"][i]["main"]["temp"] <= -10){
					htmlString+="<div class='temp-hour tempkgm10'>";
				}
			htmlString+=+weatherData["list"][i]["main"]["temp"]+"°</div><img class='weatherIcon-hour' alt='"+weatherData["list"][i]["weather"][0]["icon"]+".png' src='http://openweathermap.org/img/w/"+weatherData["list"][i]["weather"][0]["icon"]+".png'></div></div></li>";		

			tempDate.setHours(tempDate.getHours()+3);

			if(tempDate.getHours() == 0) {
				tempDateDays.setDate(tempDateDays.getDate()+1);
			}
	}
	
	var divWidth=weatherData["cnt"]*80;
	$('#scroller-hour').css("width", divWidth+"px");
	$('#list-hour').html(""+htmlString);
	$('#headerCur').html(location+" aktuell "+mainTemp+"°"); 
	var tempDate;
	htmlString="";

	for(var i=0;i<weatherData2["cnt"];i++)
	{
		tempDate = new Date(localDateObj.getFullYear(), localDateObj.getMonth(), localDateObj.getDate()+i);
		var label="";
		if(i==0)
		{
			label="heute";
		}
		if(i==1)
		{
			label="morgen";
		}
		if(i>1)
		{
			label=weekday[tempDate.getDay()];
		}
		var month = '0' + (tempDate.getMonth() + 1);
	    month = month.slice(-2, (month.length - 2) + 3);
	    var day = '0' + tempDate.getDate();
		day = day.slice(-2, (day.length - 2) + 3);
		var dateToDisplay=day+"."+month+".";
		
		htmlString+="<li id='day"+i+"'><div class='list-day-weatherText'><div class='dayTop list-day-top-select'>"+label+"<br>"+dateToDisplay+"</div><div class='dayBottom list-day-bottom-select'><div class='temp-day'><span class='maxMin'>max</span><br>";
		
		if(weatherData2["list"][i]["max"] > 25){
			htmlString+="<div class='maxContent tempg25'>";
		}
		else if(weatherData2["list"][i]["temp"]["max"] > 20 && weatherData2["list"][i]["temp"]["max"] <= 25){
			htmlString+="<div class='maxContent tempg20'>";
		}
		else if(weatherData2["list"][i]["temp"]["max"] > 15 && weatherData2["list"][i]["temp"]["max"] <= 20){
			htmlString+="<div class='maxContent tempg15'>";
		}
		else if(weatherData2["list"][i]["temp"]["max"] > 0 && weatherData2["list"][i]["temp"]["max"] <= 15){
			htmlString+="<div class='maxContent tempg0'>";
		}
		else if(weatherData2["list"][i]["temp"]["max"] > -10 && weatherData2["list"][i]["temp"]["max"] <= 0){
			htmlString+="<div class='maxContent tempgm10'>";
		}
		else if(weatherData2["list"][i]["temp"]["max"] <= -10){
			htmlString+="<div class='maxContent tempkgm10'>";
		}
		
		htmlString+=+weatherData2["list"][i]["temp"]["max"]+"°</div><br><span class='maxMin'>min</span><br>";
		
		if(weatherData2["list"][i]["temp"]["min"] > 25){
			htmlString+="<div class='minContent tempg25'>";
		}
		else if(weatherData2["list"][i]["temp"]["min"] > 20 && weatherData2["list"][i]["temp"]["min"] <= 25){
			htmlString+="<div class='minContent tempg20'>";
		}
		else if(weatherData2["list"][i]["temp"]["min"] > 15 && weatherData2["list"][i]["temp"]["min"] <= 20){
			htmlString+="<div class='minContent tempg15'>";
		}
		else if(weatherData2["list"][i]["temp"]["min"] > 0 && weatherData2["list"][i]["temp"]["min"] <= 15){
			htmlString+="<div class='minContent tempg0'>";
		}
		else if(weatherData2["list"][i]["temp"]["min"] > -10 && weatherData2["list"][i]["temp"]["min"] <= 0){
			htmlString+="<div class='minContent tempgm10'>";
		}
		else if(weatherData2["list"][i]["temp"]["min"] <= -10){
			htmlString+="<div class='minContent tempkgm10'>";
		}
		
		htmlString+=+weatherData2["list"][i]["temp"]["min"]+"°</div><img class='weatherIcon-day' alt='"+weatherData2["list"][i]["weather"][0]["icon"]+".png' src='http://openweathermap.org/img/w/"+weatherData2["list"][i]["weather"][0]["icon"]+".png'></div></div></div></li>";
	}

	$('#list-day').html(""+htmlString);
	divWidth=weatherData2["cnt"]*80;
	$('#scroller-day').css("width", divWidth+"px");
}

function initApp()
{
	var searchInput=document.getElementById('searchString');
	searchInput.onkeyup = function() { 
	    getData('searchString');
	}
	initializeDB();
}


function getData(id)
{
	var searchString = $('#'+id).val();
	
	if(searchString=="")
	{
		$('#results').html("");
		$('#results').css("height", "0px");
	}
	else
	{
		jQuery.support.cors = true;
		var xhr = new XMLHttpRequest({mozSystem: true});
		xhr.open("GET", "http://api.openweathermap.org/data/2.5/find?q="+searchString+"&units=metric&type=accurate&cnt=3&"+appid, true); 
		xhr.onreadystatechange = function () {
		    if (xhr.status === 200 && xhr.readyState === 4) {
		  	  displayData(xhr.response);
		    }
		}
	
		xhr.onerror = function () {
			alert(xhr.response);
		};
		xhr.send();
	}
}


function getGeoID(id)
{
	var searchString = $('#'+id).html();
	
	if(searchString!="")
	{
		jQuery.support.cors = true;
		var xhr = new XMLHttpRequest({mozSystem: true});
		xhr.open("GET", "http://api.openweathermap.org/data/2.5/weather?q="+searchString+"&units=metric&"+appid, true);
		
		xhr.onreadystatechange = function () {
		    if (xhr.status === 200 && xhr.readyState === 4) {
		  	  var jData=JSON.parse(xhr.response);
				var geoID=jData["id"];
				$('#results').html("");
				$('#results').css("height", "50px");
				addLocationToDB(jData["name"],geoID);
		    }
		}
	
		xhr.onerror = function () {
			alert(xhr.response);
		};
		xhr.send();
	}
} 

function displayData(data)
{
    var jData=JSON.parse(data);
    var resultString="<li class='ui-li ui-li-static ui-btn-up-c ui-first-child'>kein treffer</li>";
    $('#results').css("height", "50px");     
    
    if(jData["list"].length!=0)
	{
	    var resultString="<ul class='myList2'>";

	    for(var i=0;i<jData["list"].length;i++)
	    {
	    	resultString+="<li class='myList' id='result"+i+"'>"+jData["list"][i]["name"]+","+jData["list"][i]["sys"]["country"]+"</li>";
	    }
	}
    
    $('#results').css("height", (jData["list"].length*50)+"px");
    $('#results').html(resultString);
    for(var i=0;i<jData["list"].length;i++)
    {
    	var searchResult=document.getElementById('result'+i);
    	searchResult.onclick = function() { 
	        getGeoID(this.id);
	   }
    }
}